<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "snse_admin".
 *
 * @property int $id
 * @property int $customer_id
 * @property int $staff_id
 * @property int $channelpartner_id
 * @property int $sm_cp_id
 * @property string $username
 * @property string $password
 * @property string $email
 * @property string $activkey
 * @property int $superuser 1-superuser,2-no superadmin
 * @property int $role 1-customer,2-superadmin,3-admin,4-dataentry
 * @property string $question
 * @property string $create_at
 * @property string $lastvisit_at
 * @property int|null $status
 * @property int $projects_id
 */
class Admin extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'snse_admin';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_id', 'staff_id', 'channelpartner_id', 'sm_cp_id', 'superuser', 'role', 'status', 'projects_id'], 'integer'],
            [['create_at', 'lastvisit_at'], 'safe'],
            [['username'], 'string', 'max' => 100],
            [['password', 'email', 'activkey'], 'string', 'max' => 128],
            [['question'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'customer_id' => 'Customer ID',
            'staff_id' => 'Staff ID',
            'channelpartner_id' => 'Channelpartner ID',
            'sm_cp_id' => 'Sm Cp ID',
            'username' => 'Username',
            'password' => 'Password',
            'email' => 'Email',
            'activkey' => 'Activkey',
            'superuser' => 'Superuser',
            'role' => 'Role',
            'question' => 'Question',
            'create_at' => 'Create At',
            'lastvisit_at' => 'Lastvisit At',
            'status' => 'Status',
            'projects_id' => 'Projects ID',
        ];
    }
}
