<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "log_error".
 *
 * @property int $id
 * @property string $url
 * @property string $post_data
 * @property string $error
 * @property string $created_on
 */
class LogError extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'log_error';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['url', 'error', 'created_on'], 'required'],
            [['post_data', 'error'], 'string'],
            [['created_on'], 'safe'],
            [['url'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'url' => 'Url',
            'post_data' => 'Post Data',
            'error' => 'Error',
            'created_on' => 'Created On',
        ];
    }
}
