<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "marketing_campaign".
 *
 * @property int $id
 * @property string|null $campaign_id
 * @property string|null $title
 * @property string|null $website
 * @property int|null $created_by
 * @property string|null $created_on
 * @property int|null $modified_by
 * @property string|null $modified_on
 * @property int $status
 */
class MarketingCampaign extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'marketing_campaign';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_by', 'modified_by', 'status'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['campaign_id'], 'string', 'max' => 50],
            [['title', 'website'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'campaign_id' => 'Campaign ID',
            'title' => 'Title',
            'website' => 'Website',
            'created_by' => 'Created By',
            'created_on' => 'Created On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
            'status' => 'Status',
        ];
    }
}
