<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "marketing_campaign_content".
 *
 * @property int $id
 * @property int $campaign_id
 * @property string $content
 * @property string|null $created_on
 * @property int|null $created_by
 * @property string|null $modified_on
 * @property int|null $modified_by
 */
class MarketingCampaignContent extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'marketing_campaign_content';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['campaign_id', 'content'], 'required'],
            [['campaign_id', 'created_by', 'modified_by'], 'integer'],
            [['created_on', 'modified_on'], 'safe'],
            [['content'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'campaign_id' => 'Campaign ID',
            'content' => 'Content',
            'created_on' => 'Created On',
            'created_by' => 'Created By',
            'modified_on' => 'Modified On',
            'modified_by' => 'Modified By',
        ];
    }
}
