<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "snse_banner".
 *
 * @property int $id
 * @property int|null $dooit_id
 * @property string $name
 * @property string $description
 * @property string $location
 * @property int $splotch_img
 * @property int $status
 * @property int $projects_id
 * @property string $created_on
 * @property string $updated_on
 */
class SnseBanner extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'snse_banner';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['dooit_id', 'splotch_img', 'status', 'projects_id'], 'integer'],
            [['name', 'projects_id'], 'required'],
            [['created_on', 'updated_on'], 'safe'],
            [['name'], 'string', 'max' => 255],
            [['description', 'location'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'dooit_id' => 'Dooit ID',
            'name' => 'Name',
            'description' => 'Description',
            'location' => 'Location',
            'splotch_img' => 'Splotch Img',
            'status' => 'Status',
            'projects_id' => 'Projects ID',
            'created_on' => 'Created On',
            'updated_on' => 'Updated On',
        ];
    }
}
