<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "projects".
 *
 * @property int $id
 * @property string $name
 * @property string|null $brief It is used for frontside
 * @property string|null $approved_by
 * @property string|null $amenities
 * @property string $signification
 * @property string $connectivity
 * @property string $project_status
 * @property string $launch_date
 * @property int $status
 * @property string $website_address
 * @property string $logo_name
 * @property string $pdf_upload
 * @property string $project_description
 * @property string $rera_no
 * @property string $no_of_tower
 * @property string $site_address
 * @property string|null $sale_address
 * @property string $offer
 * @property string $landmark
 * @property string $overlooking
 * @property string $possession_date
 * @property string $flat_configuration
 * @property string $project_segment 1.Affordable value,2.Luxury,3.Ultra luxury,4.Value
 * @property string $ticket_size 1.30 to 50 Lac,2.50 to 80Lac,3.80 to 1 cr,4.1 to 1.5 cr
 * @property string $total_area
 * @property string $structure
 * @property int $location_id
 * @property int $builder_id
 * @property int $work_stage_id
 * @property int $total_unit
 * @property int $unit_to_be_sold
 * @property string $concern_person
 * @property string|null $mobile_view_expiry
 * @property int $concern_no
 * @property string|null $google_map
 * @property string|null $google_link
 * @property string $created_on
 * @property string $modified_on
 */
class Projects extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'projects';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'signification', 'connectivity', 'project_status', 'launch_date', 'status', 'website_address', 'logo_name', 'pdf_upload', 'project_description', 'rera_no', 'no_of_tower', 'site_address', 'offer', 'landmark', 'overlooking', 'possession_date', 'flat_configuration', 'project_segment', 'ticket_size', 'total_area', 'structure', 'location_id', 'builder_id', 'total_unit', 'concern_person', 'concern_no'], 'required'],
            [['signification', 'connectivity', 'project_description', 'google_map'], 'string'],
            [['launch_date', 'possession_date', 'mobile_view_expiry', 'created_on', 'modified_on'], 'safe'],
            [['status', 'location_id', 'builder_id', 'work_stage_id', 'total_unit', 'unit_to_be_sold', 'concern_no'], 'integer'],
            [['name', 'structure'], 'string', 'max' => 50],
            [['brief', 'approved_by', 'logo_name', 'pdf_upload', 'rera_no', 'landmark', 'overlooking', 'concern_person', 'google_link'], 'string', 'max' => 100],
            [['amenities', 'no_of_tower', 'sale_address', 'offer', 'flat_configuration', 'project_segment', 'ticket_size', 'total_area'], 'string', 'max' => 150],
            [['project_status'], 'string', 'max' => 35],
            [['website_address'], 'string', 'max' => 125],
            [['site_address'], 'string', 'max' => 120],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'brief' => 'Brief',
            'approved_by' => 'Approved By',
            'amenities' => 'Amenities',
            'signification' => 'Signification',
            'connectivity' => 'Connectivity',
            'project_status' => 'Project Status',
            'launch_date' => 'Launch Date',
            'status' => 'Status',
            'website_address' => 'Website Address',
            'logo_name' => 'Logo Name',
            'pdf_upload' => 'Pdf Upload',
            'project_description' => 'Project Description',
            'rera_no' => 'Rera No',
            'no_of_tower' => 'No Of Tower',
            'site_address' => 'Site Address',
            'sale_address' => 'Sale Address',
            'offer' => 'Offer',
            'landmark' => 'Landmark',
            'overlooking' => 'Overlooking',
            'possession_date' => 'Possession Date',
            'flat_configuration' => 'Flat Configuration',
            'project_segment' => 'Project Segment',
            'ticket_size' => 'Ticket Size',
            'total_area' => 'Total Area',
            'structure' => 'Structure',
            'location_id' => 'Location ID',
            'builder_id' => 'Builder ID',
            'work_stage_id' => 'Work Stage ID',
            'total_unit' => 'Total Unit',
            'unit_to_be_sold' => 'Unit To Be Sold',
            'concern_person' => 'Concern Person',
            'mobile_view_expiry' => 'Mobile View Expiry',
            'concern_no' => 'Concern No',
            'google_map' => 'Google Map',
            'google_link' => 'Google Link',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
        ];
    }
}
