<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;


/**
 * This is the model class for table "sm_cp".
 *
 * @property int $sm_cp_id
 * @property int $builder_id
 * @property int $channelpartner_id
 * @property string $name
 * @property string $email
 * @property int $contact
 * @property int $role 1=>'Team lead',2=>'Manager',3=>'Executive'
 * @property int|null $parent_id
 * @property int $status
 * @property int $created_by
 * @property int $modified_by
 * @property string $created_on
 * @property string $modified_on
 * @property int $created_from 1->mobile app, 2-> crm
 * @property string $apikey
 * @property int $is_logged
 * @property string $login_at
 * @property string $logout_at
 */
class SmCp extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sm_cp';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'contact', 'status', 'role', 'channelpartner_id'], 'required'],
            [['builder_id', 'channelpartner_id', 'contact', 'role', 'parent_id', 'status', 'created_by', 'modified_by', 'created_from', 'is_logged'], 'integer'],
            [['created_on', 'modified_on', 'logout_at', 'login_at'], 'safe'],
            [['name', 'email'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'sm_cp_id' => 'Sm Cp ID',
            'builder_id' => 'Builder ID',
            'channelpartner_id' => 'Channelpartner ID',
            'name' => 'Name',
            'email' => 'Email',
            'contact' => 'Contact',
            'role' => 'Role',
            'parent_id' => 'Parent ID',
            'status' => 'Status',
            'created_by' => 'Created By',
            'modified_by' => 'Modified By',
            'created_on' => 'Created On',
            'modified_on' => 'Modified On',
            'created_from' => 'Created From',
            'apikey' => 'Apikey',
            'is_logged' => 'Is Logged',
            'login_at' => 'Login At',
            'logout_at' => 'Logout At',
        ];
    }

    /* public function relations()
    {
        return array(
            'channelpartner' => array(self::HAS_MANY, 'Channelpartner', 'channelpartner_id'),
            'builder' => array(self::BELONGS_TO, 'Builder', 'builder_id'),
            'parent' => array(self::BELONGS_TO, 'SmCp', 'parent_id'),
        );
    } */

    public function getCp()
    {
        return $this->hasOne(Channelpartner::class, ['id' => 'channelpartner_id']);
    }

    public function getParent()
    {
        return $this->hasOne(SmCp::class, ['parent_id' => 'id']);
    }
}
