<?php

namespace app\modules\api\controllers;

use app\models\Common;
use app\models\Faqmaster;
use app\models\Location;
use app\models\SmCpNetwork;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class FaqController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'list' => ['GET'],
                        'detail' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['list', 'detail'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();

                $data['success']['code'] = 'FAQ_LIST_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['FAQ_LIST_DISPLAYED_SUCCESSFULLY'];

                $get_faq_list = $common_model->getfaqlistapi($get_user, $querydata, 1);
                $data['data'] = $get_faq_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting faq list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting faq list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting faq list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting faq list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionDetail()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        $formdata = $this->request->get();
        $id = $formdata['id'];

        try {
            if (!empty($id)) {
                $faq_data = Faqmaster::find()->where('id="' . $id . '" ')->one();
                if (!empty($faq_data)) {

                    $common_model = new Common();
                    //check if cp has access to lead
                    $data['success']['code'] = 'FAQ_DETAIL_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['FAQ_DETAIL_DISPLAYED_SUCCESSFULLY'];
                    $get_faq_details = $common_model->getfaqapi($faq_data->id, $faq_data);
                    $data['data'] = $get_faq_details;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'FAQ_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['FAQ_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting faq detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting faq detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting faq detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting faq detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}