<?php

namespace app\modules\api\controllers;


use app\models\Location;
use app\models\SmCp;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;

class LoginController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'index' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['index'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionIndex()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;

        if (!empty($this->request->post())) {
            $post_data = $this->request->post();
            $post_contact = isset($post_data['contact']) ? $post_data['contact'] : '';
            if (!empty($post_contact)) {
                //check if login exists
                $get_login_data = SmCp::find()->where(['in', 'status', [1, 2]])->andWhere(['<>', 'channelpartner_id', 0])->andWhere(['contact', $post_contact])->one();
                if (!empty($get_login_data)) {
                    //show user details
                    //send otp to the user
                    //send token to the user
                } else {
                    //send user not exists message

                }
            } else {
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } else {
            $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
            $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }









        return $data;
    }
}
