<?php

namespace app\modules\api\controllers;

use app\models\Builder;
use app\models\Common;
use app\models\Location;
use app\models\Projects;
use app\models\SmCp;
use app\models\SmCpBookmark;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class ProjectController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'detail' => ['GET'],
                        'list' => ['GET'],
                        'listname' => ['GET'],
                        'listbuilder' => ['GET'],
                        'listsm' => ['GET'],
                        'bookmark' => ['POST'],
                        'bookmarklist' => ['GET'],
                        'amenities' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['detail', 'bookmark', 'list', 'listname', 'listbuilder', 'listsm', 'bookmarklist', 'amenities'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }

    public function actionDetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                //check if project exist
                $pr_data = Projects::find()->select('name')->where(['id' => $id])->one();
                if (!empty($pr_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;

                        $common_model = new Common();
                        //check if cp has access to project
                        $check_access = $common_model->checkcpprojaccess($cp_id, $id);
                        if ($check_access) {
                            $data['success']['code'] = 'PROJECT_DETAIL_SUCCESSFUL';
                            $data['success']['message'] = \Yii::$app->params['PROJECT_DETAIL_SUCCESSFUL'];
                            $get_proj_details = $common_model->getprojectapi($id, $sm_cp_id);
                            $data['data'] = $get_proj_details;
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'PROJECT_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['PROJECT_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting project detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionBookmark($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /*  $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            if (!empty($id)) {

                //check if project exist
                $pr_data = Projects::find()->select('name')->where(['id' => $id])->one();
                if (!empty($pr_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;

                        $common_model = new Common();
                        //check if cp has access to project
                        $check_access = $common_model->checkcpprojaccess($cp_id, $id);
                        if ($check_access) {

                            if (!empty($this->request->post())) {
                                $formdata['SmCpBookmark'] = $this->request->post();
                                if (empty($formdata['SmCpBookmark']['bookmark'])) {
                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                    $data['error'] = $error_data;
                                } else {
                                    //check entries of that project
                                    $sql_check = "SELECT id FROM sm_cp_bookmark WHERE sm_cp_id='" . $sm_cp_id . "' AND projects_id='" . $id . "' ";
                                    $bookmark_count = SmCpBookmark::findBySql($sql_check)->count();

                                    if ($formdata['SmCpBookmark']['bookmark'] == 'true') {
                                        if ($bookmark_count == 0) {
                                            $formdata['SmCpBookmark']['sm_cp_id'] = $sm_cp_id;
                                            $formdata['SmCpBookmark']['projects_id'] = $id;
                                            $formdata['SmCpBookmark']['created_on'] = date('Y-m-d H:i:s');

                                            $smcpbookmark_model = new SmCpBookmark();
                                            if ($smcpbookmark_model->load($formdata)) {
                                                if ($smcpbookmark_model->save()) {
                                                    $data['success']['code'] = 'BOOKMARK_ADDED_SUCCESSFULY';
                                                    $data['success']['message'] = \Yii::$app->params['BOOKMARK_ADDED_SUCCESSFULY'];
                                                } else {
                                                    $formerrordata['post_data'] = "error while saving data in project bookmark " . json_encode($formdata);
                                                    $formerrordata['error'] = json_encode($smcpbookmark_model->getErrors());
                                                    Yii::$app->common->addlog($formerrordata);

                                                    $data['status'] = 2;
                                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                    //$error['error'] = $error;
                                                    $data['error'] = $error_data;
                                                    Yii::$app->response->statusCode = 500;
                                                }
                                            } else {
                                                $formerrordata['post_data'] = "error while loading data in project bookmark " . json_encode($formdata);
                                                $formerrordata['error'] = json_encode($smcpbookmark_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $data['success']['code'] = 'BOOKMARK_ADDED_SUCCESSFULY';
                                            $data['success']['message'] = \Yii::$app->params['BOOKMARK_ADDED_SUCCESSFULY'];
                                        }
                                    } else if ($formdata['SmCpBookmark']['bookmark'] == 'false') {
                                        if ($bookmark_count == 0) {
                                            $data['success']['code'] = 'BOOKMARK_REMOVED_SUCCESSFULY';
                                            $data['success']['message'] = \Yii::$app->params['BOOKMARK_REMOVED_SUCCESSFULY'];
                                        } else {
                                            $data['success']['code'] = 'BOOKMARK_REMOVED_SUCCESSFULY';
                                            $data['success']['message'] = \Yii::$app->params['BOOKMARK_REMOVED_SUCCESSFULY'];
                                            $bookmark_delete = SmCpBookmark::find()
                                                ->where(['sm_cp_id' => $sm_cp_id])
                                                ->andwhere(['projects_id' => $id])
                                                ->one()
                                                ->delete();
                                        }
                                    }
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }


                            /* if ($data['status'] == 1) {
                                $get_proj_details = $common_model->getprojectapi($id, $sm_cp_id);
                                $data['data'] = $get_proj_details;
                            } */
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = 'MEMBER_NO_ACCESS';
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                        Yii::$app->response->statusCode = 401;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'PROJECT_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['PROJECT_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while posting bookmark project";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while posting bookmark project";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while posting bookmark project";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while posting bookmark project";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }


    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();
                /* echo "<pre>";
                print_r($querydata);
                exit; */

                $data['success']['code'] = 'PROJECTS_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['PROJECTS_LISTED_SUCCESSFULY'];

                $get_proj_list = $common_model->getprojectlistapi($get_user, $querydata);
                $data['data'] = $get_proj_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting project list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionAmenities()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                $querydata = $this->request->get();
                unset($querydata['r']);

                $data['success']['code'] = 'AMENITIES_LISTED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['AMENITIES_LISTED_SUCCESSFULLY'];

                $get_amenities_list = $common_model->getamenities();
                $data['data'] = $get_amenities_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting amenities list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting amenities list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting amenities list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting amenities list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListname()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();

                $data['success']['code'] = 'PROJECTS_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['PROJECTS_LISTED_SUCCESSFULY'];

                $get_proj_list = $common_model->getprojectlistapi($get_user, $querydata, 1);
                $data['data'] = $get_proj_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project list only name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project list only name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project list only name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting project list only name";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionListsm()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;

        $headers = $this->request->headers;
        $get_user_data = Yii::$app->common->apikey_verify($headers);

        /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

        if (!empty($get_user_data['sm_cp_data'])) {
            $get_user = $get_user_data['sm_cp_data'];

            $sm_cp_id = $get_user->sm_cp_id;
            $cp_id = $get_user->channelpartner_id;

            $querydata = $this->request->get();

            if (!empty($querydata)) {
                $project_id = (!empty($querydata['project_id']) ? trim($querydata['project_id']) : '');
                if (!empty($project_id)) {

                    //need to work from here
                    $common_model = new Common();
                    $get_proj_sm = $common_model->getsmofproject($project_id);

                    if (!empty($get_proj_sm)) {
                        $get_proj_sm_txt = implode(",", $get_proj_sm);
                    } else {
                        $get_proj_sm_txt = "-1";    //show no sm
                    }

                    $get_sm_data = SmCp::find()->select('sm_cp_id, name')->where('status=1 AND sm_cp_id IN(' . $get_proj_sm_txt . ')')->asArray()->all();

                    if (!empty($get_sm_data)) {

                        $sm_arr = [];
                        $sm_count = 0;
                        foreach ($get_sm_data as $get_sm_data_val) {
                            $sm_arr[$sm_count]['sm_id'] = $get_sm_data_val['sm_cp_id'];
                            $sm_arr[$sm_count]['name'] = $get_sm_data_val['name'];
                            $sm_count++;
                        }

                        $data['data']['sm'] = $sm_arr;
                        $data['success']['code'] = 'SM_LISTED_SUCCESSFULY';
                        $data['success']['message'] = \Yii::$app->params['SM_LISTED_SUCCESSFULY'];
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'SM_NOT_FOUND';
                        $error_data['message'] = \Yii::$app->params['SM_NOT_FOUND'];
                        //$error['error'] = $error_data;
                        $data['error'] = $error_data;
                        //return json_encode($error);
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                $data['error'] = $error_data;
            }
        } else {
            $data['status'] = 2;
            $data['error'] = $get_user_data['error'];
            Yii::$app->response->statusCode = 401;
        }
        return $data;
    }

    public function actionListbuilder()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        //$data['success'] = null;
        //$data['error'] = null;
        //$data['data'] = null;

        $headers = $this->request->headers;
        $get_user_data = Yii::$app->common->apikey_verify($headers);

        /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

        if (!empty($get_user_data['sm_cp_data'])) {
            $get_user = $get_user_data['sm_cp_data'];

            $sm_cp_id = $get_user->sm_cp_id;
            $cp_id = $get_user->channelpartner_id;

            $common_model = new Common();

            $getbuilder = $common_model->getbuilderofcp($cp_id);
            if (!empty($getbuilder)) {
                $getbuilder_txt = implode(",", $getbuilder);
                $get_builder_data = Builder::find()->select('id, name')->where('status=1 AND id IN(' . $getbuilder_txt . ')')->asArray()->all();
                /* $get_builder_data = Builder::find()->select('id, name')->where(['status' => 1])->asArray()->all(); */
                /* echo "<pre>";
                print_r($get_builder_data);
                exit; */
                if (!empty($get_builder_data)) {
                    $data['data']['builder'] = $get_builder_data;
                    $data['success']['code'] = 'BUILDERS_LISTED_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['BUILDERS_LISTED_SUCCESSFULY'];
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'BUILDER_NOT_FOUND';
                    $error_data['message'] = \Yii::$app->params['BUILDER_NOT_FOUND'];
                    //$error['error'] = $error_data;
                    $data['error'] = $error_data;
                    //return json_encode($error);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = 'BUILDER_NOT_FOUND';
                $error_data['message'] = \Yii::$app->params['BUILDER_NOT_FOUND'];
                //$error['error'] = $error_data;
                $data['error'] = $error_data;
            }
        } else {
            $data['status'] = 2;
            $data['error'] = $get_user_data['error'];
            Yii::$app->response->statusCode = 401;
        }
        return $data;
    }

    public function actionBookmarklist()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->get();

                $data['success']['code'] = 'PROJECTS_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['PROJECTS_LISTED_SUCCESSFULY'];

                $get_proj_list = $common_model->getprojectlistbookmarkapi($get_user, $querydata);
                $data['data'] = $get_proj_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting project bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting project bookmark list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}