<?php

namespace app\modules\api\controllers;

use app\models\Admin;
use app\models\Channelpartner;
use app\models\Common;
use app\models\Location;
use app\models\SmCp;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class SmcpController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'create' => ['POST'],
                        'update' => ['PUT'],
                        'list' => ['GET'],
                        'profile' => ['GET'],
                        'member' => ['GET'],
                        'manager' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['create', 'update', 'list', 'profile', 'member', 'manager'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionUpdate($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;
                if (!empty($id) && in_array($get_user->status, [1, 2])) {

                    //check if member has access over the smcp
                    $get_access_smcp = $common_model->getaccessmembers($sm_cp_id);
                    if (!in_array($id, $get_access_smcp)) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                }

                if ($update_success) {
                    if (!empty($this->request->post())) {
                        $formdata['SmCp'] = $this->request->post();
                        if (
                            empty($formdata['SmCp'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = 'REQUIRED_PARAMS_MISSING_code';
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {

                            $formdata['SmCp']['modified_on'] = date('Y-m-d H:i:s');
                            $formdata['SmCp']['modified_by'] = $get_user->sm_cp_id;


                            //if user trying to update contact check if already exist.
                            if (!empty($formdata['SmCp']['contact'])) {
                                if (!empty($id)) {
                                    $sql_check = "SELECT sm_cp_id FROM sm_cp WHERE contact='" . $formdata['SmCp']['contact'] . "' and sm_cp_id != '" . $id . "' ";
                                } else {
                                    $sql_check = "SELECT sm_cp_id FROM sm_cp WHERE contact='" . $formdata['SmCp']['contact'] . "' and sm_cp_id != '" . $sm_cp_id . "' ";
                                }
                                $user_count = SmCp::findBySql($sql_check)->count();
                                if ($user_count != 0) {
                                    $update_success = false;
                                    $data['status'] = 2;
                                    $error_data['code'] = 'MEMBER_ALREADY_EXIST';
                                    $error_data['message'] = str_replace("%", $formdata['SmCp']['contact'], \Yii::$app->params['MEMBER_ALREADY_EXIST']);
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }

                            if (!empty($id)) {
                                $update_smcp_model = SmCp::findOne(['sm_cp_id' => $id]);
                            } else {
                                $update_smcp_model = SmCp::findOne(['sm_cp_id' => $sm_cp_id]);
                            }

                            if (!empty($formdata['SmCp']['parent_id'])) {
                                if (!empty($formdata['SmCp']['role'])) {
                                    $get_user_role = $formdata['SmCp']['role'];
                                } else {
                                    $get_user_role = $update_smcp_model->role;
                                }
                                $getparent_smcp_model = SmCp::findOne(['sm_cp_id' => $formdata['SmCp']['parent_id']]);
                                if ((intval($get_user_role) <= intval($getparent_smcp_model->role)) || intval($getparent_smcp_model->role) == 3) {
                                    //unset($formdata['SmCp']['parent_id']);
                                    $update_success = false;
                                    $data['status'] = 2;
                                    $error_data['code'] = 'PARENT_ROLE_LESS';
                                    $error_data['message'] = \Yii::$app->params['PARENT_ROLE_LESS'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }


                            if ($update_success) {


                                if (!empty($id)) {
                                    /* if (!empty($formdata['SmCp']['role'])) {
                                        if (intval($get_user->role) >= intval($formdata['SmCp']['role'])) {
                                            unset($formdata['SmCp']['role']);
                                            if (!empty($formdata['SmCp']['parent_id'])) {
                                                unset($formdata['SmCp']['parent_id']);
                                            }
                                        }
                                    } */
                                    if (!empty($formdata['SmCp']['parent_id'])) {
                                        if (!empty($formdata['SmCp']['role'])) {
                                            $get_user_role = $formdata['SmCp']['role'];
                                        } else {
                                            $get_user_role = $update_smcp_model->role;
                                        }
                                        $getparent_smcp_model = SmCp::findOne(['sm_cp_id' => $formdata['SmCp']['parent_id']]);
                                        if (intval($get_user_role) < intval($getparent_smcp_model->role)) {
                                            unset($formdata['SmCp']['parent_id']);
                                        }
                                    }
                                } else {
                                    if (!empty($formdata['SmCp']['role'])) {
                                        unset($formdata['SmCp']['role']);
                                    }
                                    if (!empty($formdata['SmCp']['parent_id'])) {
                                        unset($formdata['SmCp']['parent_id']);
                                    }
                                }

                                foreach ($formdata['SmCp'] as $formdata_key => $formdata_val) {
                                    if (in_array($formdata_key, ['name', 'email', 'contact', 'role', 'parent_id'])) {
                                        $update_smcp_model->$formdata_key = $formdata_val;
                                    }
                                }
                                if ($update_smcp_model->save()) {
                                    if ($update_smcp_model->role == 1) {
                                        //If team leader updates his name or contact or email then it should be updated in CP table also.
                                        if (
                                            !empty($formdata['SmCp']['name']) ||
                                            !empty($formdata['SmCp']['contact']) ||
                                            !empty($formdata['SmCp']['email'])
                                        ) {
                                            //update in channel partner table
                                            $update_cp_model = Channelpartner::findOne(['id' => $cp_id]);
                                            if (!empty($formdata['SmCp']['name'])) {
                                                $update_cp_model->name = $formdata['SmCp']['name'];
                                            }
                                            if (!empty($formdata['SmCp']['contact'])) {
                                                $update_cp_model->contact = $formdata['SmCp']['contact'];
                                            }
                                            if (!empty($formdata['SmCp']['email'])) {
                                                $update_cp_model->email_id = $formdata['SmCp']['email'];
                                            }
                                            $update_cp_model->save();
                                        }
                                    }

                                    if (!empty($id)) {
                                        $data['success']['code'] = 'MEMBER_UPDATED_SUCCESSFUL';
                                        $data['success']['message'] = \Yii::$app->params['MEMBER_UPDATED_SUCCESSFUL'];
                                        //get member details
                                        $get_member = $common_model->getsinglesmcpapi($id);
                                        if (!empty($get_member)) {
                                            $data['data']['member'] = $get_member;
                                        }
                                    } else {
                                        $data['success']['code'] = 'PROFILE_UPDATED_SUCCESSFUL';
                                        $data['success']['message'] = \Yii::$app->params['PROFILE_UPDATED_SUCCESSFUL'];
                                        //get member details
                                        $get_member = $common_model->getsinglesmcpapi($sm_cp_id);
                                        if (!empty($get_member)) {
                                            $data['data']['profile'] = $get_member;
                                        }
                                    }
                                } else {
                                    $formerrordata['post_data'] = "error while updating member " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($update_smcp_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                    Yii::$app->response->statusCode = 500;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionMember($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $get_success = true;
                if (empty($id)) {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $get_success = false;
                }
                if (!empty($id) && in_array($get_user->status, [1, 2])) {

                    //check if member has access over the smcp
                    $common_model = new Common();
                    $get_access_smcp = $common_model->getaccessmembers($sm_cp_id);
                    if (!in_array($id, $get_access_smcp)) {
                        $data['status'] = 2;
                        $error_data['code'] = 'MEMBER_NO_ACCESS';
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $get_success = false;
                    }
                }

                if ($get_success) {
                    //get member details
                    $get_member = $common_model->getsinglesmcpapi($id);
                    if (!empty($get_member)) {
                        $data['success']['code'] = 'MEMBER_DISPLAYED_SUCCESSFULY';
                        $data['success']['message'] = \Yii::$app->params['MEMBER_DISPLAYED_SUCCESSFULY'];
                        $data['data']['member'] = $get_member;
                    } else {
                        $data['status'] = 2;
                        $data['error']['code'] = 'MEMBER_NOT_EXIST';
                        $data['error']['message'] = str_replace("%", $id, \Yii::$app->params['MEMBER_NOT_EXIST']);
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while get member ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionManager()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        $common_model = new Common();
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $get_success = true;

                if ($get_user->role != 1) {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                    $get_success = false;
                }

                if ($get_success) {
                    //get manager details
                    $get_manager = $common_model->getmanagers($get_user);
                    if (!empty($get_manager)) {
                        $data['success']['code'] = 'MANAGERS_DISPLAYED_SUCCESSFULY';
                        $data['success']['message'] = \Yii::$app->params['MANAGERS_DISPLAYED_SUCCESSFULY'];
                        $data['data']['team'] = $get_manager;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting managers ";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                if (in_array($get_user->status, [1, 2])) {
                    if (!empty($this->request->post())) {
                        $formdata['SmCp'] = $this->request->post();
                        if (
                            empty($formdata['SmCp']['name']) ||
                            empty($formdata['SmCp']['contact']) ||
                            empty($formdata['SmCp']['role'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {
                            $formdata['SmCp']['status'] = 1;
                            if (empty($formdata['SmCp']['parent_id'])) {
                                $formdata['SmCp']['parent_id'] = $get_user->sm_cp_id;
                            }
                            /*  if ($get_user->role == 1) {
                                if ($formdata['SmCp']['role'] == 1) {
                                    $formdata['SmCp']['role'] = 2;
                                    $formdata['SmCp']['parent_id'] = $get_user->sm_cp_id;
                                }
                            } else if ($get_user->role == 2) {
                                if ($formdata['SmCp']['role'] == 1 || $formdata['SmCp']['role'] == 2) {
                                    $formdata['SmCp']['role'] = 3;
                                    $formdata['SmCp']['parent_id'] = $get_user->sm_cp_id;
                                }
                            } */
                            $formdata['SmCp']['channelpartner_id'] = $get_user->channelpartner_id;
                            $formdata['SmCp']['created_on'] = date('Y-m-d H:i:s');
                            $formdata['SmCp']['modified_on'] = date('Y-m-d H:i:s');

                            $update_success = true;
                            if (!empty($formdata['SmCp']['parent_id'])) {
                                if (!empty($formdata['SmCp']['role'])) {
                                    $get_user_role = $formdata['SmCp']['role'];
                                }
                                $getparent_smcp_model = SmCp::findOne(['sm_cp_id' => $formdata['SmCp']['parent_id']]);
                                if ((intval($get_user_role) <= intval($getparent_smcp_model->role)) || intval($getparent_smcp_model->role) == 3) {
                                    //unset($formdata['SmCp']['parent_id']);
                                    $update_success = false;
                                    $data['status'] = 2;
                                    $error_data['code'] = 'PARENT_ROLE_LESS';
                                    $error_data['message'] = \Yii::$app->params['PARENT_ROLE_LESS'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }

                            if ($update_success) {
                                //check entries of that contact
                                $sql_check = "SELECT sm_cp_id FROM sm_cp WHERE contact='" . $formdata['SmCp']['contact'] . "' ";
                                $user_count = SmCp::findBySql($sql_check)->count();
                                if ($user_count == 0) {

                                    //pending from here
                                    $smcp_model = new SmCp();
                                    if ($smcp_model->load($formdata)) {
                                        if ($smcp_model->save()) {

                                            //save data in admin table
                                            $sm_cp_id = $smcp_model->sm_cp_id;
                                            //add details in snse_admin table
                                            $admin_model = new Admin();
                                            $formadmindata['Admin'] = null;
                                            $formadmindata['Admin']['sm_cp_id'] = $sm_cp_id;
                                            $admin_email = !empty($formdata['SmCp']['email']) ? $formdata['SmCp']['email'] : '';
                                            $formadmindata['Admin']['username'] = $admin_email;
                                            $formadmindata['Admin']['password'] = md5($formdata['SmCp']['name'] . "@123");
                                            $formadmindata['Admin']['email'] = $admin_email;
                                            $formadmindata['Admin']['role'] = 1;
                                            $formadmindata['Admin']['create_at'] = date('Y-m-d H:i:s');
                                            $formadmindata['Admin']['status'] = 1;

                                            if ($admin_model->load($formadmindata)) {
                                                if ($admin_model->save()) {
                                                    $data['success']['code'] = 'MEMBER_ADDED_SUCCESSFULY';
                                                    $data['success']['message'] = \Yii::$app->params['MEMBER_ADDED_SUCCESSFULY'];

                                                    //get member details
                                                    $common_model = new Common();
                                                    $get_member = $common_model->getsinglesmcpapi($sm_cp_id);
                                                    if (!empty($get_member)) {
                                                        $data['data']['member'] = $get_member;
                                                    }
                                                } else {
                                                    $formerrordata['post_data'] = "error while saving data in snse_admin " . json_encode($formadmindata);
                                                    $formerrordata['error'] = json_encode($admin_model->getErrors());
                                                    Yii::$app->common->addlog($formerrordata);

                                                    $data['status'] = 2;
                                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                    //$error['error'] = $error;
                                                    $data['error'] = $error_data;
                                                    Yii::$app->response->statusCode = 500;
                                                }
                                            } else {
                                                $formerrordata['post_data'] = "error while loading data in snse_admin " . json_encode($formadmindata);
                                                $formerrordata['error'] = json_encode($admin_model->getErrors());
                                                Yii::$app->common->addlog($formerrordata);

                                                $data['status'] = 2;
                                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                                //$error['error'] = $error;
                                                $data['error'] = $error_data;
                                                Yii::$app->response->statusCode = 500;
                                            }
                                        } else {
                                            $formerrordata['post_data'] = "error while saving data in smcp " . json_encode($formdata);
                                            $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            $data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            $data['error'] = $error_data;
                                            Yii::$app->response->statusCode = 500;
                                        }
                                    } else {
                                        $formerrordata['post_data'] = "error while loading data in smcp " . json_encode($formdata);
                                        $formerrordata['error'] = json_encode($smcp_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                        Yii::$app->response->statusCode = 500;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $error_data['code'] = 'MEMBER_ALREADY_EXIST';
                                    $error_data['message'] = str_replace("%", $formdata['SmCp']['contact'], \Yii::$app->params['MEMBER_ALREADY_EXIST']);
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while create smcp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                if (in_array($get_user->status, [1, 2])) {
                    $sm_cp_id = $get_user->sm_cp_id;
                    //get members list
                    $common_model = new Common();
                    $get_members = $common_model->getmembersapi($sm_cp_id);

                    $data['success']['code'] = 'MEMBER_LISTED_SUCCESSFULY';
                    $data['success']['message'] = \Yii::$app->params['MEMBER_LISTED_SUCCESSFULY'];
                    $data['data']['members'] = $get_members;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'MEMBER_NO_ACCESS';
                    $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting member list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }

    public function actionProfile()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */
        $formdata['Ticket'] = null;
        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $data['success']['code'] = 'USER_PROFILE_LISTED_SUCCESSFULY';
                $data['success']['message'] = \Yii::$app->params['USER_PROFILE_LISTED_SUCCESSFULY'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                //get cp details
                $get_cp = $common_model->getcp($cp_id);
                $data['data']['channelPartner'] = $get_cp;
                //get logged details
                $get_logged = $common_model->getloggeduser($get_user);
                $data['data']['loggedUser'] = $get_logged;
                //get members list
                $get_members = $common_model->getmembersapi($sm_cp_id);
                $data['data']['members'] = $get_members;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
                Yii::$app->response->statusCode = 401;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting profile list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
            Yii::$app->response->statusCode = 500;
        }
        return $data;
    }
}
