<?php

namespace app\modules\api\controllers;

use app\models\Channelpartner;
use app\models\Common;
use app\models\Location;
use app\models\LogError;
use app\models\SmCp;
use app\models\SmCpOtp;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class UserController extends Controller
{
    public $role = array('1' => 'Team Lead', '2' => 'Manager', '3' => 'Executive');
    public $status = array('1' => 'Active', '2' => 'Pending', '0' => 'InActive');
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'verifycontact' => ['POST'],
                        'otprequest' => ['POST'],
                        'verifyotp' => ['POST'],
                        'logout' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['verifycontact', 'otprequest', 'verifyotp', 'logout'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionVerifycontact()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';

            if (!empty($get_contact)) {

                $query = SmCp::find()
                    ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number')
                    ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                    ->where(['sm_cp.contact' => $get_contact]);
                $get_data = $query->asArray()->all();
                $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                if (!empty($get_smcp_data)) {
                    if ($get_smcp_data['smcpstatus'] == 1) {
                        if ($get_smcp_data['cpstatus'] == 1) {
                            $data['success']['cpStatus'] = 2;
                            $data['success']['code'] = 'CP_REGISTERED_ACTIVE';
                            $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_ACTIVE'];
                        } else if ($get_smcp_data['cpstatus'] == 2) {
                            $data['success']['cpStatus'] = 3;
                            $data['success']['code'] = 'CP_REGISTERED_PENDING';
                            $data['success']['message'] = \Yii::$app->params['CP_REGISTERED_PENDING_message'];
                        } else {
                            $data['success']['cpStatus'] = 4;
                            $data['success']['code'] = 'CP_DEACTIVATED';
                            $data['success']['message'] = \Yii::$app->params['CP_DEACTIVATED_message'];
                        }
                    } else {
                        $data['success']['cpStatus'] = 4;
                        $data['success']['code'] = 'CP_DEACTIVATED';
                        $data['success']['message'] = \Yii::$app->params['CP_DEACTIVATED_message'];
                    }
                } else {
                    $data['success']['cpStatus'] = 1;
                    $data['success']['code'] = 'CP_UNREGISTERED';
                    $data['success']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_UNREGISTERED']);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
                //$this->header('HTTP/1.1 400: BAD REQUEST');
                //return json_encode($error);
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while verify contact " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }

        return $data;
    }

    public function actionOtprequest()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';

            if (!empty($get_contact)) {

                $query = Channelpartner::find()
                    ->select('sm_cp.status AS smcpstatus,channelpartner.status AS cpstatus,channelpartner.rera_number')
                    ->leftJoin("sm_cp", 'sm_cp.channelpartner_id = channelpartner.id')
                    ->where('sm_cp.contact="' . $get_contact . '" OR channelpartner.contact="' . $get_contact . '"');

                $get_data = $query->asArray()->all();
                $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                if (!empty($get_smcp_data)) {

                    //check entries of otp for that contact
                    $sql_check = "SELECT id FROM sm_cp_otp WHERE created_on between '" . date('Y-m-d 00:00:00') . "' AND '" . date('Y-m-d 23:59:59') . "' AND contact='" . $get_contact . "' ";
                    $otp_count = SmCpOtp::findBySql($sql_check)->count();

                    if ($otp_count < \Yii::$app->params['OTP_MAX']) {
                        $send_sms = Yii::$app->common->send_sms('otp', $get_contact);
                        if ($send_sms) {
                            $data['success']['code'] = 'OTP_REQUEST_SUCCESSFUL';
                            $data['success']['message'] = str_replace("%", $get_contact, \Yii::$app->params['OTP_REQUEST_SUCCESSFUL']);
                        } else {
                            $data['status'] = 2;
                            $data['error']['code'] = 'OTP_REQUEST_FAILED';
                            $data['error']['message'] = \Yii::$app->params['OTP_REQUEST_FAILED'];
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error']['code'] = 'OTP_SENDING_EXCEEDED';
                        $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['OTP_SENDING_EXCEEDED']);
                    }
                } else {
                    $data['status'] = 2;
                    $data['error']['code'] = 'CP_NOT_EXIST';
                    $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
                //$this->header('HTTP/1.1 400: BAD REQUEST');
                //return json_encode($error);
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while otp request " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }

        return $data;
    }

    public function actionVerifyotp()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        //api for checking if cp exist
        $formdata = $this->request->post();

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {

            $get_contact = !empty($formdata['contact']) ? trim($formdata['contact']) : '';
            $get_type = !empty($formdata['type']) ? trim($formdata['type']) : '';
            $get_otp = !empty($formdata['otp']) ? trim($formdata['otp']) : '';

            if (!empty($get_contact) && !empty($get_type) && !empty($get_otp)) {

                $query_smcpotp = SmCpOtp::find()
                    ->select('id')
                    ->where('contact="' . $get_contact . '" AND otp="' . $get_otp . '" AND expiry_at > "' . date('Y-m-d H:i:s') . '"')->orderBy('id DESC')->limit(1);

                $get_data_smcpotp = $query_smcpotp->asArray()->all();
                $get_otp_data = !empty($get_data_smcpotp[0]) ? $get_data_smcpotp[0] : [];
                $get_otp_data = 1234;
                if (!empty($get_otp_data)) {
                    if ($get_type == 2) {
                        $data['success']['code'] = 'OTP_VERIFICATION_SUCCESSFUL';
                        $data['success']['message'] = Yii::$app->params['OTP_VERIFICATION_SUCCESSFUL'];
                    } else {


                        $query = SmCp::find()
                            ->select('sm_cp.status AS smcpstatus,cp.status AS cpstatus,cp.rera_number,sm_cp.channelpartner_id,sm_cp.name,sm_cp.email,sm_cp.contact,sm_cp.role,sm_cp.created_on,sm_cp.modified_on,sm_cp.sm_cp_id')
                            ->leftJoin("channelpartner as cp", 'sm_cp.channelpartner_id = cp.id')
                            ->where(['sm_cp.contact' => $get_contact]);
                        $get_data = $query->asArray()->all();
                        $get_smcp_data = !empty($get_data[0]) ? $get_data[0] : [];

                        if (!empty($get_smcp_data)) {
                            if ($get_smcp_data['smcpstatus'] == 1) {
                                if ($get_smcp_data['cpstatus'] == 1) {
                                    //active cp user


                                    //generate API key and update logged in
                                    $key_data = $get_smcp_data['sm_cp_id'] . time();
                                    $apikey = md5($key_data);

                                    $smcpmodel = SmCp::find()->where(['sm_cp_id' => $get_smcp_data['sm_cp_id']])->one();
                                    $smcpmodel->apikey = $apikey;
                                    $smcpmodel->is_logged = 1;
                                    $smcpmodel->login_at = date('Y-m-d H:i:s');
                                    if ($smcpmodel->save()) {
                                        $data['success']['code'] = 'OTP_VERIFICATION_SUCCESSFUL';
                                        $data['success']['message'] = Yii::$app->params['OTP_VERIFICATION_SUCCESSFUL'];

                                        $loggedUser['channelpartner_id'] = $get_smcp_data['channelpartner_id'];
                                        $loggedUser['name'] = $get_smcp_data['name'];
                                        $loggedUser['email'] = $get_smcp_data['email'];
                                        $loggedUser['contact'] = $get_smcp_data['contact'];

                                        $loggedUser['role'] = $this->role[$get_smcp_data['role']];

                                        $loggedUser['status'] = $this->status[$get_smcp_data['smcpstatus']];
                                        $loggedUser['created_on'] = $get_smcp_data['created_on'];
                                        $loggedUser['modified_on'] = $get_smcp_data['modified_on'];
                                        $loggedUser['sm_cp_id'] = $get_smcp_data['sm_cp_id'];
                                        $loggedUser['apikey'] = $apikey;
                                        $data['data']['loggedUser'] = $loggedUser;

                                        if ($get_smcp_data['role'] == 1 || $get_smcp_data['role'] == 2) {
                                            //get members list
                                            $common_model = new Common();
                                            $get_members = $common_model->getmembersapi($get_smcp_data['sm_cp_id']);
                                            if (!empty($get_members)) {
                                                $data['data']['members'] = $get_members;
                                            }
                                        }
                                    } else {
                                        $formerrordata['post_data'] = "error while updating apikey " . json_encode($get_smcp_data);
                                        $formerrordata['error'] = json_encode($smcpmodel->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                } else {
                                    $data['status'] = 2;
                                    $data['error']['code'] = 'CP_NOT_EXIST';
                                    $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                                }
                            } else {
                                $data['status'] = 2;
                                $data['error']['code'] = 'CP_NOT_EXIST';
                                $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                            }
                        } else {
                            $data['status'] = 2;
                            $data['error']['code'] = 'CP_NOT_EXIST';
                            $data['error']['message'] = str_replace("%", $get_contact, \Yii::$app->params['CP_NOT_EXIST']);
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $data['error']['code'] = 'INVALID_OTP';
                    $data['error']['message'] = str_replace("%", $get_otp, \Yii::$app->params['INVALID_OTP']);
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
                //$this->header('HTTP/1.1 400: BAD REQUEST');
                //return json_encode($error);
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {

            $formerrordata['post_data'] = "error while verify otp " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);


            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }

        return $data;
    }

    public function actionLogout()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $headers = $this->request->headers;
        $apikey = '';
        if (!empty($headers)) {
            $apikey = $headers->get('apikey');
        }

        $data = null;
        $data['status'] = 1;
        /* $data['success'] = null;
        $data['error'] = null;
        $data['data'] = null; */

        try {
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $get_user->apikey = null;
                $get_user->is_logged = 0;
                $get_user->logout_at = date('Y-m-d H:i:s');
                if ($get_user->save()) {
                    $data['success']['code'] = 'LOGOUT_SUCCESSFUL';
                    $data['success']['message'] = \Yii::$app->params['LOGOUT_SUCCESSFUL'];
                } else {
                    $formerrordata['post_data'] = "error while updating logout " . json_encode($this->request->headers);
                    $formerrordata['error'] = json_encode($get_user->getErrors());
                    Yii::$app->common->addlog($formerrordata);

                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while logout " . json_encode($this->request->headers);
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }

        return $data;
    }
}
