<?php

namespace app\modules\api\controllers;


use app\models\Location;

use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class LocationController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'list' => ['GET'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['list'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }




    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        $get_loc_data = Location::find()->select('id, name')->where(['status' => 1])->asArray()->all();

        if (!empty($get_loc_data)) {
            $data['data'] = $get_loc_data;
            $data['success']['code'] = 'LOCATION_LISTED_SUCCESSFULLY';
            $data['success']['message'] = \Yii::$app->params['LOCATION_LISTED_SUCCESSFULLY_message'];
        } else {
            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['LOCATION_NOT_FOUND_code'];
            $error_data['message'] = \Yii::$app->params['LOCATION_NOT_FOUND_message'];
            //$error['error'] = $error_data;
            $data['error'] = $error_data;
            //return json_encode($error);
        }
        return $data;
    }
}
