<?php

namespace app\modules\api\controllers;

use app\models\Common;
use app\models\Location;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class MarketingController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'list' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['list'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                $querydata = $this->request->post();

                $data['success']['code'] = 'MARKETING_ITEMS_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['MARKETING_ITEMS_DISPLAYED_SUCCESSFULLY'];

                $get_market_list = $common_model->getmarketlistapi($get_user, $querydata);
                $data['data'] = $get_market_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting marketing list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }
}
