<?php

namespace app\modules\api\controllers;

use app\models\Common;
use app\models\Leadmaster;
use app\models\Location;
use app\models\TaggingFeedback;
use app\models\Taggingmaster;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class TaggingController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'create' => ['POST'],
                        'createmultiple' => ['POST'],
                        'detail' => ['GET'],
                        'update' => ['PUT'],
                        'stats' => ['GET'],
                        'monthly' => ['POST'],
                        'delete' => ['DELETE'],
                        'list' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['create', 'createmultiple', 'detail', 'stats', 'update', 'delete', 'list', 'monthly'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                if (!empty($this->request->post())) {
                    $formdata['Taggingmaster'] = $this->request->post();
                    $lead_model = Leadmaster::findOne(['id' => $formdata['Taggingmaster']['lead_id']]);
                    if (empty($lead_model)) {
                        $data['status'] = 2;
                        $error_data['code'] = 'LEAD_NOT_EXIST';
                        $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['lead_id'], \Yii::$app->params['LEAD_NOT_EXIST']);
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    } else {
                        $formdata['Taggingmaster']['tag_name'] = $lead_model->name;
                        $formdata['Taggingmaster']['tag_email'] = $lead_model->email;
                        $formdata['Taggingmaster']['tag_phone'] = $lead_model->contact;
                        $formdata['Taggingmaster']['budget'] = $lead_model->budget;
                        $formdata['Taggingmaster']['followup_date'] = $lead_model->followup_date;
                        $formdata['Taggingmaster']['customer_type'] = $lead_model->customer_type;
                        $formdata['Taggingmaster']['flat_type_id'] = $lead_model->flat_type_id;

                        $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                        if (
                            empty($formdata['Taggingmaster']['lead_id']) ||
                            empty($formdata['Taggingmaster']['project_id']) ||
                            empty($formdata['Taggingmaster']['appointment_date']) ||
                            empty($formdata['Taggingmaster']['sm_cp_id']) ||
                            empty($formdata['Taggingmaster']['appointment_time'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else if (($formdata['Taggingmaster']['appointment_date'] < date('Y-m-d')) || ($formdata['Taggingmaster']['appointment_date'] > $twodate)) {
                            $data['status'] = 2;
                            $error_data['code'] = 'APPOINTMENT_DATE_ONLY_TWO_DAYS';
                            $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_ONLY_TWO_DAYS'];
                            $data['error'] = $error_data;
                        } else {
                            $formdata['Taggingmaster']['created_by'] = $sm_cp_id;
                            $formdata['Taggingmaster']['cp_id'] = $cp_id;
                            $formdata['Taggingmaster']['created_on'] = date('Y-m-d H:i:s');
                            $formdata['Taggingmaster']['modified_by'] = $sm_cp_id;
                            $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');

                            //check entries of that contact for project
                            $sql_check = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND cp_id='" . $cp_id . "' ";
                            $user_count = Taggingmaster::findBySql($sql_check)->count();
                            if ($user_count == 0) {
                                $tagging_model = new Taggingmaster();


                                if ($tagging_model->load($formdata)) {
                                    if ($tagging_model->save()) {

                                        $tag_id = $tagging_model->id;
                                        //update lead id and get lead details
                                        $tagging_model->tagging_id = "TAG" . date('d') . date('m') . date('y') . $tag_id;
                                        $tagging_model->save();

                                        $common_model = new Common();
                                        $data['success']['code'] = 'TAGGING_CREATED_SUCCESSFULLY';
                                        $data['success']['message'] = \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY'];

                                        $get_tag = $common_model->gettagapi($tag_id, $tagging_model);
                                        $data['data'] = $get_tag;
                                    } else {

                                        $formerrordata['post_data'] = "error while adding data in taggingmaster " . json_encode($formdata);
                                        $formerrordata['error'] = json_encode($lead_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        $data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        $data['error'] = $error_data;
                                    }
                                } else {
                                    $formerrordata['post_data'] = "error while loading data in taggingmaster " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($lead_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            } else {
                                $data['status'] = 2;
                                $error_data['code'] = 'TAGGING_ALREADY_EXIST';
                                $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['tag_phone'], \Yii::$app->params['TAGGING_ALREADY_EXIST']);
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }

    public function actionUpdate($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];
        $formdata['Ticket'] = [];
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;
                if (!empty($id)) {

                    //check if member has access over the lead
                    $get_access_smcp = $common_model->checkcptagaccess($sm_cp_id, $id);
                    if (!$get_access_smcp) {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                    //check if tag is in status of 0,2.
                    $update_tag_model = Taggingmaster::findOne(['id' => $id]);
                    if (!empty($update_tag_model)) {
                        if (!in_array($update_tag_model->status, [0, 2])) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['TAGGING_ALREADY_PROCESSED'];
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_ALREADY_PROCESSED']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['TAGGING_NOT_EXIST'];
                        $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $update_success = false;
                }

                if ($update_success) {
                    if (!empty($this->request->post())) {
                        $formdata['Taggingmaster'] = $this->request->post();
                        if (
                            empty($formdata['Taggingmaster'])
                        ) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                            $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                            $data['error'] = $error_data;
                        } else {

                            $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');
                            $formdata['Taggingmaster']['modified_by'] = $get_user->sm_cp_id;

                            if ($update_success) {

                                foreach ($formdata['Taggingmaster'] as $formdata_key => $formdata_val) {
                                    $update_tag_model->$formdata_key = $formdata_val;
                                }
                                if ($update_tag_model->save()) {

                                    if (!empty($formdata['Taggingmaster']['feedback'])) {
                                        //Add entry in feedback table
                                        $tag_feedback_model = new TaggingFeedback();
                                        $tag_feedback_model->tagging_id = $id;
                                        $tag_feedback_model->feedback = $formdata['Taggingmaster']['feedback'];
                                        $tag_feedback_model->created_on = date('Y-m-d H:i:s');
                                        $tag_feedback_model->created_by = $sm_cp_id;
                                        $tag_feedback_model->save();
                                    }

                                    $data['success']['code'] = 'TAGGING_UPDATED_SUCCESSFULLY';
                                    $data['success']['message'] = \Yii::$app->params['TAGGING_UPDATED_SUCCESSFULLY'];
                                    $get_tag = $common_model->gettagapi($id, $update_tag_model, 1);
                                    $data['data'] = $get_tag;
                                } else {
                                    $formerrordata['post_data'] = "error while updating tag " . json_encode($formdata);
                                    $formerrordata['error'] = json_encode($update_tag_model->getErrors());
                                    Yii::$app->common->addlog($formerrordata);

                                    $data['status'] = 2;
                                    $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                    $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                    //$error['error'] = $error;
                                    $data['error'] = $error_data;
                                }
                            }
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                        $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while update tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }

    public function actionDelete($id = '')
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];
        $formdata['Ticket'] = [];
        try {
            $common_model = new Common();
            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];
                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $update_success = true;
                if (!empty($id)) {

                    //check if member has access over the lead
                    $get_access_smcp = $common_model->checkcptagaccess($sm_cp_id, $id);
                    if (!$get_access_smcp) {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                        $update_success = false;
                    }
                    //check if tag is processed.
                    $update_tag_model = Taggingmaster::findOne(['id' => $id]);
                    if (empty($update_tag_model)) {
                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['TAGGING_NOT_EXIST'];
                        $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                        $data['error'] = $error_data;
                        $update_success = false;
                    } else {
                        if ($update_tag_model->status != 0) {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['TAGGING_ALREADY_PROCESSED'];
                            $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_ALREADY_PROCESSED']);
                            $data['error'] = $error_data;
                            $update_success = false;
                        }
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                    $update_success = false;
                }

                if ($update_success) {
                    if ($update_tag_model->delete()) {
                        //delete feedback
                        $del_feed_data = TaggingFeedback::deleteAll(['tagging_id' => $id]);
                        $data['success']['code'] = 'TAGGING_DELETED_SUCCESSFULLY';
                        $data['success']['message'] = \Yii::$app->params['TAGGING_DELETED_SUCCESSFULLY'];
                    } else {
                        $formerrordata['post_data'] = "error while deleting tag " . json_encode($formdata);
                        $formerrordata['error'] = json_encode($update_tag_model->getErrors());
                        Yii::$app->common->addlog($formerrordata);

                        $data['status'] = 2;
                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while deleting tag " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }

    public function actionDetail($id)
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {
            if (!empty($id)) {

                $tag_data = Taggingmaster::find()->where('id="' . $id . '" ')->one();
                if (!empty($tag_data)) {
                    $headers = $this->request->headers;
                    $get_user_data = Yii::$app->common->apikey_verify($headers);
                    if (!empty($get_user_data['sm_cp_data'])) {
                        $get_user = $get_user_data['sm_cp_data'];

                        $sm_cp_id = $get_user->sm_cp_id;
                        $cp_id = $get_user->channelpartner_id;

                        $common_model = new Common();
                        //check if cp has access to lead
                        $check_access = $common_model->checkcptagaccess($sm_cp_id, $id);
                        if ($check_access) {
                            $data['success']['code'] = 'TAGGING_DETAIL_DISPLAYED_SUCCESSFULLY';
                            $data['success']['message'] = \Yii::$app->params['TAGGING_DETAIL_DISPLAYED_SUCCESSFULLY'];
                            $get_tag_details = $common_model->gettagapi($id, $tag_data, 1);
                            $data['data'] = $get_tag_details;
                        } else {
                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            $error_data['message'] = \Yii::$app->params['MEMBER_NO_ACCESS'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $data['error'] = $get_user_data['error'];
                    }
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = 'TAGGING_NOT_EXIST';
                    $error_data['message'] = str_replace("%", $id, \Yii::$app->params['TAGGING_NOT_EXIST']);
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tagging detail";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }

    public function actionList()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->post();

                $data['success']['code'] = 'TAGGING_LIST_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['TAGGING_LIST_DISPLAYED_SUCCESSFULLY'];

                $get_tag_list = $common_model->gettaglistapi($get_user, $querydata);
                $data['data'] = $get_tag_list;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tag list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }

    public function actionStats()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);
            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();

                $data['success']['code'] = 'TAGGING_STATS_DISPLAYED_SUCCESSFULLY';
                $data['success']['message'] = \Yii::$app->params['TAGGING_STATS_DISPLAYED_SUCCESSFULLY'];
                $get_tag_stats = $common_model->gettagstatsapi($sm_cp_id);
                $data['data'] = $get_tag_stats;
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting tag stats";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }

    public function actionMonthly()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            /* echo Yii::$app->request->hostInfo . Yii::$app->request->url;
            exit; */

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;

                $common_model = new Common();
                /* $querydata = $this->request->get();
                unset($querydata['r']); */
                $querydata = $this->request->post();

                if (!empty($querydata)) {

                    $tag_year = (!empty($querydata['year']) ? trim($querydata['year']) : date('Y'));
                }
                if ($tag_year > date('Y') || $tag_year < 2023) {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_YEAR'];
                    $error_data['message'] = \Yii::$app->params['INVALID_YEAR'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                } else {

                    $data['success']['code'] = 'TAGGING_STATS_DISPLAYED_SUCCESSFULLY';
                    $data['success']['message'] = \Yii::$app->params['TAGGING_STATS_DISPLAYED_SUCCESSFULLY'];

                    $get_tag_list = $common_model->gettagstatsmonthlyapi($get_user, $querydata);
                    $data['data'] = $get_tag_list;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while getting monthly tags stats list";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }


    public function actionCreatemultiple()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;


        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];

        try {

            $headers = $this->request->headers;
            $get_user_data = Yii::$app->common->apikey_verify($headers);

            if (!empty($get_user_data['sm_cp_data'])) {
                $get_user = $get_user_data['sm_cp_data'];

                $sm_cp_id = $get_user->sm_cp_id;
                $cp_id = $get_user->channelpartner_id;
                $tagging = [];

                if (!empty($this->request->post())) {
                    $postdata = $this->request->post();
                    foreach ($postdata['tagging'] as $postdata_key => $postdata_val) {

                        $formdata['Taggingmaster'] = $postdata_val;
                        $lead_model = Leadmaster::findOne(['id' => $formdata['Taggingmaster']['lead_id']]);
                        if (empty($lead_model)) {
                            //$data['status'] = 2;
                            $error_data['code'] = 'LEAD_NOT_EXIST';
                            $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['lead_id'], \Yii::$app->params['LEAD_NOT_EXIST']);
                            //$error['error'] = $error;
                            //$data['error'] = $error_data;
                            $tagging[$postdata_key]['error'] = $error_data;
                        } else {
                            $formdata['Taggingmaster']['tag_name'] = $lead_model->name;
                            $formdata['Taggingmaster']['tag_email'] = $lead_model->email;
                            $formdata['Taggingmaster']['tag_phone'] = $lead_model->contact;
                            $formdata['Taggingmaster']['budget'] = $lead_model->budget;
                            $formdata['Taggingmaster']['followup_date'] = $lead_model->followup_date;
                            $formdata['Taggingmaster']['customer_type'] = $lead_model->customer_type;
                            $formdata['Taggingmaster']['flat_type_id'] = $lead_model->flat_type_id;

                            $twodate = date('Y-m-d', strtotime(' + 2 day', strtotime(date('Y-m-d'))));
                            if (
                                empty($formdata['Taggingmaster']['lead_id']) ||
                                empty($formdata['Taggingmaster']['project_id']) ||
                                empty($formdata['Taggingmaster']['appointment_date']) ||
                                empty($formdata['Taggingmaster']['sm_cp_id']) ||
                                empty($formdata['Taggingmaster']['appointment_time'])
                            ) {
                                //$data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                                $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                                //$data['error'] = $error_data;
                                $tagging[$postdata_key]['error'] = $error_data;
                            } else if (($formdata['Taggingmaster']['appointment_date'] < date('Y-m-d')) || ($formdata['Taggingmaster']['appointment_date'] > $twodate)) {
                                //$data['status'] = 2;
                                $error_data['code'] = 'APPOINTMENT_DATE_ONLY_TWO_DAYS';
                                $error_data['message'] = \Yii::$app->params['APPOINTMENT_DATE_ONLY_TWO_DAYS'];
                                //$data['error'] = $error_data;
                                $tagging[$postdata_key]['error'] = $error_data;
                            } else {
                                $formdata['Taggingmaster']['created_by'] = $sm_cp_id;
                                $formdata['Taggingmaster']['cp_id'] = $cp_id;
                                $formdata['Taggingmaster']['created_on'] = date('Y-m-d H:i:s');
                                $formdata['Taggingmaster']['modified_by'] = $sm_cp_id;
                                $formdata['Taggingmaster']['modified_on'] = date('Y-m-d H:i:s');

                                //check entries of that contact for project
                                $sql_check = "SELECT id FROM taggingmaster WHERE lead_id='" . $formdata['Taggingmaster']['lead_id'] . "' AND project_id='" . $formdata['Taggingmaster']['project_id'] . "' AND cp_id='" . $cp_id . "' ";
                                $user_count = Taggingmaster::findBySql($sql_check)->count();
                                if ($user_count == 0) {
                                    $tagging_model = new Taggingmaster();


                                    if ($tagging_model->load($formdata)) {
                                        if ($tagging_model->save()) {

                                            $tag_id = $tagging_model->id;
                                            //update lead id and get lead details
                                            $tagging_model->tagging_id = "TAG" . date('d') . date('m') . date('y') . $tag_id;
                                            $tagging_model->save();

                                            $common_model = new Common();
                                            /* $data['success']['code'] = 'TAGGING_CREATED_SUCCESSFULLY';
                                            $data['success']['message'] = \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY']; */

                                            $get_tag = $common_model->gettagapi($tag_id, $tagging_model);
                                            //$data['data'] = $get_tag;
                                            $tagging[$postdata_key]['success']['code'] =
                                                'TAGGING_CREATED_SUCCESSFULLY';
                                            $tagging[$postdata_key]['success']['message'] =
                                                \Yii::$app->params['TAGGING_CREATED_SUCCESSFULLY'];
                                            $tagging[$postdata_key]['tagginginfo'] = $get_tag['tagging'];
                                        } else {

                                            $formerrordata['post_data'] = "error while adding data in taggingmaster " . json_encode($formdata);
                                            $formerrordata['error'] = json_encode($lead_model->getErrors());
                                            Yii::$app->common->addlog($formerrordata);

                                            //$data['status'] = 2;
                                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                            //$error['error'] = $error;
                                            //$data['error'] = $error_data;
                                            $tagging[$postdata_key]['error'] = $error_data;
                                        }
                                    } else {
                                        $formerrordata['post_data'] = "error while loading data in taggingmaster " . json_encode($formdata);
                                        $formerrordata['error'] = json_encode($lead_model->getErrors());
                                        Yii::$app->common->addlog($formerrordata);

                                        //$data['status'] = 2;
                                        $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                        $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                        //$error['error'] = $error;
                                        //$data['error'] = $error_data;
                                        $tagging[$postdata_key]['error'] = $error_data;
                                    }
                                } else {
                                    //$data['status'] = 2;
                                    $error_data['code'] = 'TAGGING_ALREADY_EXIST';
                                    $error_data['message'] = str_replace("%", $formdata['Taggingmaster']['tag_phone'], \Yii::$app->params['TAGGING_ALREADY_EXIST']);
                                    //$error['error'] = $error;
                                    //$data['error'] = $error_data;
                                    $tagging[$postdata_key]['error'] = $error_data;
                                }
                            }
                        }
                    }
                    $data['data']['tagging'] = $tagging;
                } else {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                    $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                    //$error['error'] = $error;
                    $data['error'] = $error_data;
                }
            } else {
                $data['status'] = 2;
                $data['error'] = $get_user_data['error'];
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while creating tagging";
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }
}
