<?php

namespace app\modules\api\controllers;

use app\models\LogError;
use app\models\Ticket;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;


class TicketController extends Controller
{
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'create' => ['POST'],
                    ],
                ],
                'access' => [
                    'class' => AccessControl::class,
                    'rules' => [
                        [
                            'actions' => ['create'],
                            'allow' => true,
                        ],
                    ],
                ],
            ]
        );
    }


    public function actionCreate()
    {
        //Return response in json
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        $data = [];
        $data['status'] = 1;
        $data['success'] = [];
        $data['error'] = [];
        $data['data'] = [];
        $formdata['Ticket'] = [];
        try {
            if (!empty($this->request->post())) {
                $formdata['Ticket'] = $this->request->post();
                if (
                    empty($formdata['Ticket']['contact']) ||
                    empty($formdata['Ticket']['issue_type']) ||
                    empty($formdata['Ticket']['message'])
                ) {
                    $data['status'] = 2;
                    $error_data['code'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_code'];
                    $error_data['message'] = \Yii::$app->params['REQUIRED_PARAMS_MISSING_message'];
                    $data['error'] = $error_data;
                } else {

                    $formdata['Ticket']['created_on'] = date('Y-m-d H:i:s');
                    $formdata['Ticket']['modified_on'] = date('Y-m-d H:i:s');

                    //check entries of support for that contact
                    $sql_check = "SELECT id FROM ticket WHERE created_on between '" . date('Y-m-d 00:00:00') . "' AND '" . date('Y-m-d 23:59:59') . "' AND contact='" . $formdata['Ticket']['contact'] . "' ";
                    $ticket_count = Ticket::findBySql($sql_check)->count();
                    if ($ticket_count < \Yii::$app->params['TICKET_MAX']) {

                        //pending from here
                        $ticket_model = new Ticket();
                        if ($ticket_model->load($formdata)) {
                            if ($ticket_model->save()) {
                                $data['success']['code'] = 'TICKET_ADDED_SUCCESSFULLY';
                                $data['success']['message'] = \Yii::$app->params['TICKET_ADDED_SUCCESSFULLY_message'];
                            } else {
                                $formerrordata['post_data'] = "error while saving data in ticket " . json_encode($formdata);
                                $formerrordata['error'] = json_encode($ticket_model->getErrors());
                                Yii::$app->common->addlog($formerrordata);

                                $data['status'] = 2;
                                $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                                $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                                //$error['error'] = $error;
                                $data['error'] = $error_data;
                            }
                        } else {
                            $formerrordata['post_data'] = "error while loading data in ticket " . json_encode($formdata);
                            $formerrordata['error'] = json_encode($ticket_model->getErrors());
                            Yii::$app->common->addlog($formerrordata);

                            $data['status'] = 2;
                            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
                            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
                            //$error['error'] = $error;
                            $data['error'] = $error_data;
                        }
                    } else {
                        $data['status'] = 2;
                        $error_data['code'] = 'TICKET_SENDING_EXCEEDED';
                        $error_data['message'] = str_replace("%", $formdata['Ticket']['contact'], \Yii::$app->params['TICKET_SENDING_EXCEEDED']);
                        //$error['error'] = $error;
                        $data['error'] = $error_data;
                    }
                }
            } else {
                $data['status'] = 2;
                $error_data['code'] = \Yii::$app->params['INVALID_PARAM_code'];
                $error_data['message'] = \Yii::$app->params['INVALID_PARAM_message'];
                //$error['error'] = $error;
                $data['error'] = $error_data;
            }
        } catch (\yii\db\Exception $exception) {
            $formerrordata['post_data'] = "error while create ticket " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\base\Exception $exception) {
            $formerrordata['post_data'] = "error while create ticket " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\Exception $exception) {
            $formerrordata['post_data'] = "error while create ticket " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        } catch (\yii\web\BadRequestHttpException $exception) {
            $formerrordata['post_data'] = "error while create ticket " . json_encode($this->request->post());
            $formerrordata['error'] = json_encode($exception->getMessage());
            Yii::$app->common->addlog($formerrordata);

            $data['status'] = 2;
            $error_data['code'] = \Yii::$app->params['SERVER_ERROR_code'];
            $error_data['message'] = \Yii::$app->params['SERVER_ERROR_message'];
            //$error['error'] = $error;
            $data['error'] = $error_data;
        }
        return $data;
    }
}
